#ifndef CMDS_H_INCLUDED                         
#define CMDS_H_INCLUDED
												
#define DRAWPOINT "DrawPoint"
#define DRAWLINESINGLE "DrawLineSingle"
#define DRAWARC2PT "DrawArc2Pt"
#define DRAWARC3PT "DrawArc3Pt"
#define DRAWELLIPTICALARCSTARTSPAN "DrawEllipticalArcStartSpan"
#define DRAWCIRCLE2PT "DrawCircle2Pt"
#define DRAWCIRCLE3PT "DrawCircle3Pt"
#define DRAWCIRCLEDIAMETER "DrawCircleDiameter"
#define DRAWBEZIERSINGLE "DrawBezierSingle"
#define DRAWELLIPSE "DrawEllipse"
#define SETPOINTXY "SetPointXY"
#define DRAWLINECONTINUOUS "DrawLineContinuous"
#define DRAWLINEDOUBLE "DrawLineDouble"
#define DRAWRECT2PT "DrawRect2Pt"
#define DRAWRECT3PT "DrawRect3Pt"
#define DRAWRPOLYGONCENTER "DrawRPolygonCenter"
#define DRAWRPOLYGONSIDE "DrawRPolygonSide"
#define DRAWIPOLYGON "DrawIPolygon"
#define DRAWBEZIERCONT "DrawBezierCont"
#define DRAWCURVE "DrawCurve"
#define SELECTOBJECT "SelectObject"
#define SELECTWINDOW "SelectWindow"
#define SELECTCROSSING "SelectCrossing"
#define MODMOVE "ModMove"
#define MODCOPY	"ModCopy"
#define INIT_MENU_POS   0
#define DWG_MENU_POS    7

#define IDM_FILE 0
#define IDM_EDIT 1
#define IDM_DRAW 2
#define IDM_SYMBOL 3
#define IDM_MODIFY 4
#define IDM_SNAPS 5
#define IDM_ZOOMS 6
#define IDM_UTIL 7
#define IDM_WINDOW 8
#define IDM_HELP 9 
#define ID_PULLOUT      10
#define ID_PULLOUTBLACK      11
						
//#define WMX_COMMAND					1125 // WM_USER + 102
#define WMX_COMMAND					(WM_USER+102)


// FILE Section
// all tool commands defined between  CMD_ToolBase & CMD_ToolBaseEnd


///======================================   SETTINGS    =================================================
///======================================   SETTINGS    =================================================
///======================================   SETTINGS    =================================================
#define SettingBase					1100
#define TOKENSETTINGFIRST			1100
#define FIRSTVALIDTOKEN				1100


// Symbol Tokens
        #define CMD_SymClr              1101
        #define CMD_SymNm               1102
        #define CMD_SymRot				1103
        #define CMD_SymSc               1104
        #define CMD_SymScX				1105
        #define CMD_SymScY				1106
	
// Text Tokens
        #define CMD_TextChSp			1109
        #define CMD_TextClr             1110
        #define CMD_TextLay             1111
        #define CMD_TextLnSp			1112
        #define CMD_TextJust			1113
        #define CMD_TextHt				1114
        #define CMD_TextRot				1115
        #define CMD_TextAsp				1116
        #define CMD_TextBold			1117
        #define CMD_TextItalic			1118
        #define CMD_TextFont			1119
        #define CMD_TextStr				1120

// Draw Setting Tokens
        #define CMD_GridX               1123
        #define CMD_GridY               1124
        #define CMD_OrthoAngleVar       1125
        #define CMD_FilletRVar          1126
        #define CMD_UserP1Var           1127
        #define CMD_UserD1Var           1128
	
        #define CMD_SymSnapOn           1129
        #define CMD_DrawColor           1130
        #define CMD_DrawWidth           1131
        #define CMD_DrawLayer           1132
        #define CMD_DrawLtype           1133
        #define CMD_AutoFilletOn        1134
        #define CMD_AutoFilletOff       1135
        #define CMD_SolidOn             1136
        #define CMD_SolidOff            1137
        #define CMD_WallWidth1          1138
        #define CMD_WallWidth2          1139
        #define CMD_RPolySides          1140
        #define CMD_RPolyInscribeOn     1141
        #define CMD_RPolyInscribeOff    1142
        #define CMD_OrthoOn             1143
        #define CMD_OrthoOff            1144
        #define CMD_CursorFreeOn        1145
        #define CMD_CursorFreeOff       1146
        #define CMD_IncSnapOn           1147
        #define CMD_IncSnapOff          1148
        #define CMD_TrapAng             1149
        #define CMD_IncSnapSize         1150
        #define CMD_MOMode              1151
        #define CMD_MBMode              1152
        #define CMD_MRMode              1153
        #define CMD_FilletPreviewOn     1154
        #define CMD_FilletPreviewOff    1155
        #define CMD_OffsetFixed         1156
        #define CMD_OffsetUnFixed       1157
        #define CMD_ChamferDist1        1158
        #define CMD_ChamferDist2        1159
        #define CMD_OffsetDist          1160
        #define CMD_PercentSnapVal      1161
	
	
// Mod Setting Tokens
        #define CMD_MCNumCopies               1162
        #define CMD_MCRadCopies               1163
        #define CMD_MCNumRows                 1164
        #define CMD_MCScale                   1165
        #define CMD_MCAngle                   1166
        #define CMD_MCSpanAngle               1167
        #define CMD_MCScaleXY                 1168
        #define CMD_MCScaleX                  1169
        #define CMD_MCScaleY                  1170

        #define CMD_SymSnapOff                1171
        #define CMD_AllLayerEdOn              1172
        #define CMD_AllLayerEdOff             1173
        #define CMD_AllLayerSnapOn            1174
        #define CMD_AllLayerSnapOff           1175

        #define CMD_SetColor                  1176
        #define CMD_SetLtype                  1177
        #define CMD_SetLayer                  1178
        #define CMD_SetWidth                  1180
	
        #define CMD_UIOff                     1181
        #define CMD_UIOn					  1182




        #define CMD_HatchNm		1183
        #define CMD_HatchScale  1184
        #define CMD_HatchRot	1185
        #define CMD_HatchColor  1186
        #define CMD_DrawHBnd	1187
        #define CMD_FillColor   1188
        #define CMD_DrawFBnd	1189
	
        #define CMD_ExeName					1190
        #define CMD_ExplodeCLines			1191
        #define CMD_LTScaleW				1192
        #define CMD_LTScaleD				1193
        #define CMD_DllRunName				1194
        #define CMD_DllRunFunctionName		1195
        #define CMD_DllRunCmdLine			1196
        #define CMD_OleDllName				1197
        #define CMD_OleClassName			1198
        #define CMD_OleFunctionName			1199
								 
        #define CMD_FileName				1200
        #define CMD_ScrollBar				1201
        #define CMD_OleCmdLine				1202

        #define CMD_IsoMode					1203
        #define CMD_IsoLeft					1204
        #define CMD_IsoRight				1205
        #define CMD_IsoTop					1206

        #define CMD_SetMultiLineStyle		1207


// Paths

#define CMD_SYSPath  1210
#define CMD_VCDPath  1211
#define CMD_VCSPath  1212
#define CMD_VCFPath  1213
#define CMD_DWGPath  1214
#define CMD_DXFPath  1215

#define CMD_LayerUpdateAllViews  1220

#define         CMD_DatumOff     1230
#define         CMD_DatumXY              1231
#define         CMD_DatumX               1232
#define         CMD_DatumY               1233

#define CMD_UseByLayer                   1243
#define CMD_UseSymbolColor				 1244

#define	CMD_DimTextFont	1245
#define	CMD_DimTextHt	1246
#define	CMD_DimTextAsp	1247
#define	CMD_DimTextSlant	1248
#define	CMD_DimTextChSp	1249
#define	CMD_DimTextBold	1250
#define	CMD_DimTextItal	1251
#define	CMD_DimTextUnder	1252
#define	CMD_DimTextMono	1253
#define	CMD_DimTextFill	1254
#define	CMD_DimTextVert	1255
#define	CMD_DimTextInLn	1256
#define	CMD_DimTextAbove	1257
#define	CMD_DimTextCent	1258
#define	CMD_DimTextAltRo	1259
#define	CMD_DimTextOvStr	1260
#define	CMD_DimTextOvwrt	1261
#define	CMD_DimTextPreSt	1262
#define	CMD_DimTextPrefx	1263
#define	CMD_DimTextSufSt	1264
#define	CMD_DimTextSuffx	1265
#define	CMD_DimTextTol	1266
#define	CMD_DimTextTolLo	1267
#define	CMD_DimTextTolUp	1268
#define	CMD_DimTextScale	1269
#define	CMD_DimTextLnSp	1270
#define	CMD_DimAngle	1271
#define	CMD_DimArrowType	1272
#define	CMD_DimArrowSize	1273
#define	CMD_DimArrowAng	1274
#define	CMD_DimArrowFlip	1275
#define	CMD_DimFlipLeft	1276
#define	CMD_DimFlipRight	1277
#define	CMD_DimExtOffset	1278
#define	CMD_DimExtAbove	1279
#define	CMD_DimExtBelow	1280
#define	CMD_DimStretch	1281
#define	CMD_DimUseLayer	1282
#define	CMD_DimLayer	1283
#define	CMD_DimLineShow	1284
#define	CMD_DimLtArShow	1285
#define	CMD_DimRtArShow	1286
#define	CMD_DimLtExShow	1287
#define	CMD_DimRtExShow	1288
#define	CMD_DimTextShow	1289
#define	CMD_DimLineColor	1290
#define	CMD_DimLtArColor	1291
#define	CMD_DimRtArColor	1292
#define	CMD_DimLtExColor	1293
#define	CMD_DimRtExColor	1294
#define	CMD_DimTextColor	1295
#define	CMD_DimLineType	1296
#define	CMD_DimLtArType	1297
#define	CMD_DimRtArType	1298
#define	CMD_DimLtExType	1299
#define	CMD_DimRtExType	1300
#define	CMD_DimTextType	1301
#define	CMD_DimLineWidth	1302
#define	CMD_DimLtArWidth	1303
#define	CMD_DimRtArWidth	1304
#define	CMD_DimLtExWidth	1305
#define	CMD_DimRtExWidth	1306
#define	CMD_DimTextWidth	1307
#define	CMD_TextUseLayer	1308
#define	CMD_TextSlant	1309
#define	CMD_TextUnderln	1310
#define	CMD_TextMono	1311
#define	CMD_TextFill	1312
#define	CMD_AtbFont	1313
#define	CMD_AtbHt	1314
#define	CMD_AtbColor	1315
#define	CMD_AtbUseLocal	1316
#define	CMD_AtbLocalDsp	1317
#define	CMD_AtbLclLblDsp	1318
#define	CMD_AtbGlobalDsp	1319
#define	CMD_AtbGlbLblDsp	1320
#define	CMD_SymAutoExp	1321
#define	CMD_SymExplodeTo	1322
#define	CMD_OrthoAdvType	1323
#define	CMD_OrthoAdvInc	1324
#define	CMD_OrthoAdvStep	1325
#define	CMD_OrthoAdvOne	1326
#define	CMD_BasepointPt	1327
#define	CMD_PrtAddPreset	1328
#define	CMD_PrtDelPreset	1329
#define	CMD_PrtCurPreset	1330
#define	CMD_PrtDevice	1331
#define	CMD_PrtPgWidth	1332
#define	CMD_PrtPgHeight	1333
#define	CMD_PrtMargLeft	1334
#define	CMD_PrtMargBot	1335
#define	CMD_PrtMargRight	1336
#define	CMD_PrtMargTop	1337
#define	CMD_PrtScale	1338
#define	CMD_PrtOrigin	1339
#define	CMD_PrtViewType	1340
#define	CMD_PrtLandscape	1341
#define	CMD_PrtNumCopies	1342
#define	CMD_PrtRotAngle	1343
#define	CMD_PrtMetric	1344
#define	CMD_PrtFastDraw	1345
#define	CMD_PrtSelected	1346
#define	CMD_PrtToFile	1347
#define	CMD_PrtDateStamp	1348
#define	CMD_PrtAllBlack	1349
#define	CMD_PrtLW0HasWid	1350
#define	CMD_PrtLineWidth	1351
#define	CMD_PrtMovePage	1352
#define	CMD_PrtPaperSize	1353
#define	CMD_PrtPreview	1354
#define	CMD_PrtPaperLen	1355
#define	CMD_PrtPaperWid	1356
#define	CMD_PrtCenter	1357
#define	CMD_PrtStampForm	1358
#define	CMD_PrtStampSize	1359
#define	CMD_PrtStampLoc	1360
#define	CMD_PrtStampFont	1361
#define	CMD_DimDecimal	1362
#define	CMD_DimFraction	1363
#define	CMD_DimAngForm	1364
#define	CMD_DimLeadZero	1365
#define	CMD_DimUnits	1366
#define	CMD_DimSUFrac	1367
#define	CMD_DimSecond	1368
#define	CMD_DimDistForm	1369
#define	CMD_DimSecForm	1370
#define	CMD_DispDecimal	1371
#define	CMD_DispFraction	1372
#define	CMD_DispAngForm	1373
#define	CMD_DispLeadZero	1374
#define	CMD_DispUnits	1375
#define	CMD_GCDPath	1376
#define	CMD_MNUPath	1377
#define	CMD_STYPath	1378
#define	CMD_HatchDrawBnd	1379
#define	CMD_CursorSize	1380
#define	CMD_DefTool	1381
#define	CMD_ZoomFactor	1382
#define	CMD_AskCenter	1383
#define	CMD_ArrowWorld	1384
#define	CMD_AroWrldStep	1385
#define	CMD_AroScrnStep	1386
#define	CMD_BackColor	1387
#define	CMD_CursColor	1388
#define	CMD_SelColor	1389
#define	CMD_RubColor	1390
#define	CMD_ShowDrag	1391
#define	CMD_SearchTol	1392
#define	CMD_ShowLnType	1393
#define	CMD_ShowLnWidth	1394
#define	CMD_ShowFill	1395
#define	CMD_ShowHatch	1396
#define	CMD_ShowPoint	1397
#define	CMD_EnvSaveExit	1398
#define	CMD_ShiftClick	1399
#define	CMD_UseFileLock	1400
#define	CMD_UseFastProp	1401
#define	CMD_AutoBack	1402
#define	CMD_AutoBackSec	1403
#define	CMD_AutoSave	1404
#define	CMD_AutoSaveSec	1405
#define	CMD_FontSort	1406
#define	CMD_LdrTextFont	1407
#define	CMD_LdrTextHt	1408
#define	CMD_LdrTextAsp	1409
#define	CMD_LdrTextSlant	1410
#define	CMD_LdrTextChSp	1411
#define	CMD_LdrTextLnSp	1412
#define	CMD_LdrTextBold	1413
#define	CMD_LdrTextUnder	1414
#define	CMD_LdrTextItal	1415
#define	CMD_LdrTextMono	1416
#define	CMD_LdrTextFill	1417
#define	CMD_LdrArrowType	1418
#define	CMD_LdrArrowSize	1419
#define	CMD_LdrArrowAng	1420
#define	CMD_LdrOffset	1421
#define	CMD_LdrShoulder	1422
#define	CMD_FltEntity	1423
#define	CMD_FltLayer	1424
#define	CMD_FltColor	1425
#define	CMD_FltLnType	1426
#define	CMD_FltLnWidth	1427
#define	CMD_FltName	1428
#define	CMD_FltActive	1429
#define	CMD_HideLayers	1430
#define	CMD_DispLayers	1431
#define	CMD_LaySelect1	1432
#define	CMD_ZmViewName	1433
#define	CMD_ChangeLayer	1434
#define	CMD_ChangeColor	1435
#define	CMD_ChangeLType	1436
#define	CMD_ChangeLWidth	1437
#define	CMD_ChangeRealW	1438
#define	CMD_NumDivide	1439
#define	CMD_DivBreak	1440
#define	CMD_GroupProp	1441
#define	CMD_ChangeApply	1442
#define	CMD_LayerGroupApply	1443


#define TOKENSETTINGLAST				 1600

///======================================  TOOLS        =================================================
///======================================  TOOLS        =================================================
///======================================  TOOLS        =================================================
// Command ID's
// Messages sent to Main Window Frame through WM_COMMAND


#define ToolBase  2100
#define TOKENTOOLFIRST   2100

#define CMD_DrawPoint                   2101
#define CMD_DrawLineSingle				2102
#define CMD_DrawLineContinuous			2103
#define CMD_DrawRect2Pt					2104
#define CMD_DrawRect3Pt                 2105
#define CMD_DrawCircle3Pt               2106
#define CMD_DrawCircle2Pt               2107
#define CMD_DrawArc3Pt                  2108
#define CMD_DrawArc2Pt					2109
#define CMD_DrawEllipse                 2110
#define CMD_DrawBezierSingle            2111
#define CMD_DrawBezierCont              2112
#define CMD_DrawRPolygonCenter			2113
#define CMD_DrawRPolygonSide			2114
#define CMD_DrawIPolygon				2115
#define CMD_DrawLineDouble              2116
#define CMD_DrawEllipticalArcStartSpan  2117
#define CMD_LastSymbol					2119
#define CMD_SymPlace					2120
#define CMD_DrawCurve					2121
#define CMD_DrawCircleDiameter			2122
#define CMD_DrawMultiLine               2123
#define CMD_SymbolExplode               2124
#define CMD_UndoLastVertex              2125
#define CMD_UndoLastDim                 2126
#define CMD_SymPlaceFromMgr             2127

// SNAPS
#define CMD_SnapPerpendicular           2151
#define CMD_SnapTangent                 2152
#define CMD_SnapPercent                 2153
#define CMD_SnapClosestPoint			2154
#define CMD_SnapMidPoint                2155
#define CMD_SnapObject                  2156
#define CMD_SnapIntersection            2157
#define CMD_SnapNearPoint               2158
#define CMD_SnapQuad                    2159
#define CMD_SnapArcCenter               2160
#define CMD_SnapLastPoint               2161
#define CMD_SnapParallel                2162
#define CMD_IncSnap                     2163
#define CMD_SnapMid2Points              2164

// Dim,Leader,Text,Hatch Change										 
#define CMD_DimChange                   2170
#define CMD_LeaderChange                2171
#define CMD_TextChange                  2172
#define CMD_HatchChange                 2173
						 
// DIMS
#define CMD_DimDatumCurve				2178
#define CMD_LeaderCurve					2179
#define CMD_DimDatum                      2180
#define CMD_DimLinear                     2181
#define CMD_DimAngular                    2182
#define CMD_DimDialog                     2183
#define CMD_DimRadial                     2184
#define CMD_DimDiameter                   2185
#define CMD_Leader                        2186
#define CMD_DimMoveText                   2187
#define CMD_DimSlideText                  2188
#define CMD_DimMoveLine                   2189
#define CMD_DimMoveArc                    2190
#define CMD_DimEdit                       2191
#define CMD_LinDimHorz                    2192
#define CMD_LinDimVert                    2193
#define CMD_LinDimAligned                 2194
#define CMD_LinDimAngle                   2195
#define CMD_DimOrdinate                   2196
#define CMD_DimPoint                      2197
#define CMD_ChangeRefFrameFileName        2198
#define CMD_LeaderEdit                    2199
#define CMD_DimPreview                    2200



// ZOOMS Section
#define CMD_ZoomRegen                 2201
#define CMD_ZoomRegenArea             2202
#define CMD_ZoomArea                  2203
#define CMD_ZoomIn                    2204
#define CMD_ZoomOut                   2205
#define CMD_ZoomPan                   2206
#define CMD_ZoomAll                   2207
#define CMD_ZoomSelected              2208
#define CMD_ZoomPrevious              2209
#define CMD_ZoomLimits                2210
#define CMD_ZoomValue                 2211
#define CMD_ZoomView                  2212
#define CMD_NameView				  2213
#define CMD_SetBasepoint              2214
#define CMD_BackRedraw                2215
#define CMD_QuickSearch               2216
#define CMD_ZoomAllViews              2217
#define CMD_ZoomRegenAllViews         2218
#define CMD_ApplyNameView				2219
#define CMD_ApplyZoomView				2220
#define CMD_ApplyZoomValue				2221
#define CMD_ApplySymbolReplace			2222
#define CMD_ApplySelectLayer			2223
#define CMD_ApplyMultiEntityPropertyChange		2224
#define CMD_ApplySymbolCreate					2225
#define CMD_ApplyWithPoint						2226
#define CMD_ApplyRFZoomScale					2227
#define CMD_ApplyRFZoomView						2228


// MODIFY Section
#define CMD_MultiCopy                  2230
#define CMD_ModCopy                    2231
#define CMD_ModErase                   2232
#define CMD_ModMirror                  2233
#define CMD_ModMove                    2234
#define CMD_ModRotate                  2235
#define CMD_ModMovePoint               2236
#define CMD_ModFillet                  2237
#define CMD_ModDoubleTrim              2238
#define CMD_ModStretch                 2239
#define CMD_ModTrim                    2240
#define CMD_ModExtend                  2241
#define CMD_ModBreak                   2242
#define CMD_ModSelectionTrim           2243
#define CMD_ModChamfer                 2244
#define CMD_ModCornerTrim              2245
#define CMD_ModAlign                   2246
#define CMD_ModFitScale                2247
#define CMD_ModRadCopy                 2248
#define CMD_ModArrayCopy               2249
#define CMD_ModExplode                 2250
#define CMD_ModBezEdit                 2251
#define CMD_ModOffset                  2252
#define CMD_Reserve                    2253
#define CMD_ModCloseContour            2254
#define CMD_ModChange                  2255
#define CMD_ModScale                   2256
#define CMD_EraseLast                  2257
#define CMD_TUserVarP1                 2258
#define CMD_ModSelectionExtend         2259
#define CMD_ModAdjoiningToMEP          2260
#define CMD_ModOffsetMEP               2261
#define CMD_ModBooleanAdd              2262
#define CMD_ModBooleanSubtract         2263
#define CMD_ModBooleanIntersect        2264
#define CMD_WindowStretch              2265
#define CMD_SingleTargetSelectionTrim  2266
#define CMD_ModUsePlacementColorOn     2267
#define CMD_ModUsePlacementColorOff    2268

// ###NEWFEATURE Change selected Label display 11/18/96
#define CMD_ModAttributeDisplayOn			2269
#define CMD_ModAttributeDisplayOff			2270
#define CMD_ModAttributeLabelOn				2271
#define CMD_ModAttributeLabelOff	  		2272
#define CMD_ModSplitPolygon				  	2273
#define CMD_ModMergePolygons				2274
#define CMD_ModJoin							2275

#define CMD_ModCopySingle					2276
#define CMD_ModMultiBreak					2277

#define CMD_Divide							2278

// Utility
#define CMD_InspectorMatch               2300
#define CMD_MeasureDistance              2301
#define CMD_MeasureArea                  2302
#define CMD_MeasureAngle2                2303
#define CMD_MeasureAngle3                2304
#define CMD_MatchEntity                  2305
#define CMD_MatchTool                    2306
#define CMD_MeasureDone                  2308
#define CMD_PackData                     2309
#define CMD_TabletMode                   2310
#define CMD_TraceScale                   2311
#define CMD_DigDrawingAlign              2312
#define CMD_ActiveArea                   2313
#define CMD_WTConfig                     2314
#define CMD_DigInfo                      2315
#define CMD_SaveEnvironment              2316
#define CMD_FontConvert                  2317
#define CMD_WinExec                      2318
#define CMD_JustText                     2319
//brings up modal text ribalog
#define CMD_SymbolCount                  2320
#define CMD_BOM2CLIP                     2321
#define CMD_CLIP2BOM                     2322
#define CMD_DllRun                       2323
#define CMD_DoDragDrop                   2324
#define CMD_PurgeLnt                     2325
#define CMD_LoadLnt                      2326
#define CMD_OleCreateClass               2327
#define CMD_OleInvokeMethod              2328

#define CMD_ImplicitEntityEdit						2335
#define CMD_LayerGroupCombo								2336
#define CMD_FilterReset										2337
#define CMD_LayerGroupDlg									2338		 
#define CMD_LayerEdit											2339		 
						
// Misc Tools
#define CMD_SeedHatch                        2340
#define CMD_SeedFill                         2341

#define CMD_CleanData                         2342

#define CMD_SymCreate                         2351
#define CMD_HatchSelected                     2352
#define CMD_FillSelected                      2353
#define CMD_Text                              2354
#define CMD_Like                              2355
#define CMD_TextBox                           2356
#define CMD_Help                              2358
#define CMD_BoundaryHatch                     2359
#define CMD_BoundaryFill                      2360
#define CMD_About                             2361

#define CMD_AboutDlg	                        2363
#define CMD_AttributeAttach                   2364
#define CMD_AttributeCreate                   2365
#define CMD_ScriptAssign                      2366
#define CMD_AttributeEmbed                    2367
#define CMD_SpecificAttributeAttach           2368
#define CMD_AttributeEdit                     2369
#define CMD_AttributeMove                     2370
#define CMD_AttributeMultiAttach              2371
#define CMD_HelpIndex                         2372
#define CMD_HelpKey                           2373
#define CMD_HelpTechSupport                   2374
								
// Windows Section
#define CMD_WindowCascade                      2375
#define CMD_WindowTileVert                     2376
#define CMD_WindowTileHorz                     2377
#define CMD_WindowArrangeIcons                 2378
#define CMD_WindowCloseAll                     2379
#define CMD_WindowNew                          2380
#define CMD_HelpCursor                         2381
									 
// File Section
#define CMD_FileNew                            2400
#define CMD_FileOpen                           2401
#define CMD_FileSave                           2402
#define CMD_FileSaveAs                         2403
#define CMD_FileExit                           2404
#define CMD_FileClose                          2405
#define CMD_FilePrint                          2406
#define CMD_SymbolOpen                         2407
#define CMD_SymbolSave                         2408
#define CMD_ClearDrawing                       2409
#define CMD_FileMerge                          2410
#define CMD_PrintSetup                         2411
#define CMD_FilePlot                           2412
#define CMD_StyleOpen                          2413
#define CMD_StyleSave                          2414
#define CMD_AtbOpen                            2415
#define CMD_AtbSave                            2416
#define CMD_OleSaveCopyAs                      2417
// Special Ole Function
#define CMD_OleUpdate                          2418
// Special Ole Function
#define CMD_LoadMenu                           2419
#define CMD_FileRun                         2420
#define CMD_NestedRun                       2421
#define CMD_NewView                         2422
#define CMD_BirdsEye                        2423
#define CMD_PlotOptions                     2424
#define CMD_PlotSetup                          2425
#define CMD_LoadAscii                          2426
#define CMD_ResetCmdExt                        2427
#define CMD_RefFrameCreate                     2428
#define CMD_FileSend                           2429
// Send file via Exchange
#define CMD_RefFramePlace                      2430
#define CMD_Edit                               2431
#define CMD_NestedRunDll                       2432
#define CMD_LoadDrawingFromName				   2433

#define CMD_PrintNoDlg                         2437
									
// EDIT Section
#define CMD_EditUndo                           2440
#define CMD_EditRedo                           2441
#define CMD_EditCut                            2442
#define CMD_EditCopy                           2443
#define CMD_EditPaste                          2444
#define CMD_EditClear                          2445
#define CMD_SelectAll                          2446
#define CMD_ClearSelection                     2447
#define CMD_InverseSelection                   2448
#define CMD_SelectionTool                      2449
#define CMD_TrackingTool                       2450
#define CMD_Penup                              2451
#define CMD_Abort                              2452
#define CMD_SelectionFilter                    2453
#define CMD_SelectWindow                       2454
#define CMD_TrackEnd                           2455
#define CMD_SelectObject                       2456
#define CMD_NewHandle                          2457
#define CMD_SelectLayer                        2458
#define CMD_SelectCrossing                     2460
#define CMD_SelectAdjoining                    2461
#define CMD_UserPoint                          2462
#define CMD_SelectionRibalog                   2463
#define CMD_Properties                         2464
#define CMD_Color                              2465
#define CMD_Layer                              2466
#define CMD_Ltype                              2467
#define CMD_Width                              2468
#define CMD_SelectLast                         2470
#define CMD_UserMatch                          2472
#define CMD_DeSelectAll                        2473
#define CMD_UserPointPenup                     2474
#define CMD_UserPointAbort                     2475
#define CMD_Hilite                             2476
#define CMD_FastProperties                     2477
#define CMD_AllLayerEdit                       2478
#define CMD_SnapLayer                          2479
#define CMD_SymSnap                            2480
#define CMD_LayerDisplay                                         2481
#define CMD_LayerHide                                            2482
#define CMD_LayerCurrent                                         2483
#define CMD_RealWorldLW                                          2484
#define CMD_SelectLastObject                   2485
#define CMD_LayerProperties                    2486
#define CMD_LayerPropertyReset                 2487

// Dialog section
#define CMD_FillDlg                            2500
#define CMD_HatchDlg                           2501
#define CMD_DimTextVectDlg					   2502
#define CMD_AttribDlg                          2503
#define CMD_ObjectInfo                         2504
#define CMD_SpeedSym                           2505
#define CMD_SymDlg                             2506
#define CMD_DimTextDlg                         2507
#define CMD_DimArrowDlg                        2508
#define CMD_DimExtDlg                          2509
#define CMD_DimLineDlg                         2510
#define CMD_DimTolDlg                          2511
#define CMD_SymCreateDlg                       2512
#define CMD_LayerManager                       2513

#define CMD_AtbValueDlg                        2514
#define CMD_DimDisplayDlg                      2515
#define CMD_ToolBar                            2516
#define CMD_OptionMgr                          2517
#define CMD_PrintDlg                           2518
#define CMD_DimLeaderTextDlg                   2519
#define CMD_DimStringsDlg                      2520
#define CMD_TextSett                           2521
#define CMD_TextSettFromTextDlg                2522
#define CMD_StyleDlg                           2523
#define CMD_DimEditDlg                         2524
#define CMD_SymReplace                         2525
#define CMD_MeasureDistanceDlg                 2526
#define CMD_MeasureAreaDlg                     2527
#define CMD_MeasureAngleDlg                    2528
#define CMD_SymRemove                          2529

#define CMD_LineScale	                       2531
#define CMD_FilletRadius                       2532
#define CMD_OrthoAngle                         2533
#define CMD_DBLineSettings                     2534
#define CMD_RPolygonNSides                     2535
#define CMD_ChamferDist                        2536
#define CMD_GridSize                           2537
#define CMD_GridDisplay                        2538
#define CMD_SnapGrid                           2539
#define CMD_GridOrigin                         2540

#define CMD_AutoFillet                         2541
#define CMD_OrthoMode                          2542
#define CMD_CursorFree                         2543
#define CMD_DimModeSingle                      2544
#define CMD_DimModeCumulative                  2545
#define CMD_DimModePartitioned                 2546

#define CMD_TabEntity                          2547
#define CMD_TabText                            2548
#define CMD_TabHatch                           2549
#define CMD_TabDim                             2550
#define CMD_TabSystem                          2551
#define CMD_TabGeneral                         2552
#define CMD_TabConstraint                      2553
#define CMD_TabPath                            2554
#define CMD_TabDimText                         2555
#define CMD_TabNumeric                         2556
#define CMD_TabImportGCDFontMapping            2557
#define CMD_TabExportGCDFontMapping            2558
#define CMD_TabImportDWGFontMapping            2559
#define CMD_TabExportDWGFontMapping            2560
#define CMD_TabGCDFontNamePool                 2561
#define CMD_TabDWGFontNamePool                 2562
#define CMD_TabGCDSettings                     2563
#define CMD_TabDWGSettings                     2564
					
#define CMD_ConstPts                                             2565
#define CMD_HandlePts                                            2566
#define CMD_CurveTangentPoints                                   2567
#define CMD_DBaseDlg                                             2568
#define CMD_DBaseAssocList                                       2569
#define CMD_ToolbarDlg                                   2570
#define CMD_ConstraintViewDlg                            2571
#define CMD_AcadPolylineWidth                            2572

#define CMD_ACADImportExportMgr                    2573
#define CMD_GCDImportExportMgr                     2574
#define CMD_TabDWGColorImport					2575
#define CMD_TabDWGColorExport					2576
#define CMD_TabSystem1					2577
#define CMD_TabSystem2					2578
#define CMD_OrthoAdv					2579
#define	CMD_HidLayerMsg					2580

#define CMD_DimProxFixed                                 2590
#define CMD_DimHorzText                                  2591
#define CMD_DimInLineText                                2592
#define CMD_ArrowFlip                                    2600
#define CMD_TabLeader                                    2601

#define CMD_TabPlotterPenMapSettings           2602
#define CMD_TabPlotterSettings                 2603
#define CMD_TabPlotterLanguageSettings         2604

#define CMD_DimTextAlignDlg                    2605
#define CMD_LeaderEditDlg                      2606
#define CMD_DimShowDash							2607
#define	CMD_TextSettingsDlg						2608
#define CMD_DimSettingsDlg                      2609
#define CMD_LeaderSettingsDlg                   2610
									 
// Reference Frame Zooms
#define CMD_RFZoomRegen                 2611
#define CMD_RFZoomScale									2612
#define CMD_RFZoomArea                  2613
#define CMD_RFZoomIn                    2614
#define CMD_RFZoomOut                   2615
#define CMD_RFZoomPan                   2616
#define CMD_RFZoomAll                   2617
#define CMD_RFZoomView                  2618
#define CMD_RFZoomPrevious              2619
#define CMD_RFDrawBoundary              2620
#define CMD_RFBirdsEye									2621
#define CMD_RFResize                    2622
#define CMD_RFLayerManager              2623
#define CMD_RFTransparent               2624
#define CMD_RFSize                      2625
#define CMD_RFUpdateFileLink            2626
#define CMD_ToFront                     2640
#define CMD_ToBack                      2641
#define CMD_RemoveNameView							2642

// Ref Frame Dlg id
#define CMD_Tab                         2650
#define CMD_RefFrameNameDlg							2651
#define CMD_RefFrameMDIDlg              2652
#define CMD_DimScaleDlg                 2653

#define CMD_MultiLineSettingsDlg		2654
#define CMD_DateStamp					2655

#define CMD_LGUNDO                   2660
#define CMD_LGSAVE                   2661
#define CMD_LGREDO                   2663
#define CMD_LGPRINT                  2664
#define CMD_LGPASTE                  2665
#define CMD_LGOPEN                   2666
#define CMD_LGHELP                   2667
#define CMD_LGCUT                    2668
#define CMD_LGCOPYC                  2669
#define CMD_LGNEW                    2670
#define CMD_LGHELPCUR                2671
#define CMD_LGPRINTSETUP             2672

#define CMD_TextVectorSett           2700

// CMD_DimLeaderTextDlg
#define CMD_DimLeaderArrowDlg        2710
#define CMD_DimLeaderEditDlg         2711
#define CMD_DimLeaderDatumDlg        2712
#define CMD_DimLeaderSpacingDlg      2713

#define CMD_BearingDistance			2714
#define CMD_BearingSettingsDlg		2715
#define CMD_BearingLabel			2716

// V3
#define CMD_DocMgr				      2720
#define CMD_SymBreak			      2721
#define CMD_SymMend				      2722
#define CMD_SymSetInsertColor		2723
#define CMD_Customize						2724
#define CMD_RubberSheeting			2725
#define CMD_MoveToLayer					2726
#define CMD_CopyToLayer					2727

// v3 status popup
#define CMD_UnitInch					2731
#define CMD_UnitFeet					2732
#define CMD_UnitFeetInch			2733
#define CMD_UnitMile					2734

#define CMD_UnitFracInch					2735
#define CMD_UnitFracFeet					2736
#define CMD_UnitFracFeetInch			2737

#define CMD_UnitMM						2738
#define CMD_UnitCM						2739
#define CMD_UnitMeter					2740
#define CMD_UnitKilo					2741

#define CMD_XYLock					2742
// all tool commands defined between  1000+1024+76 & ToolBaseEnd

#define	CMD_WinErase		2743 //WINERASE,WE, ,Window &Erase,Erase by Window,HI;CS;SW;@;@;ER;HI;
#define	CMD_ObjErase		2744 //OBJERASE,OE, ,Object E&rase,Object Erase,CS;HI;SB;@;ER;HI;
#define	CMD_WinMove			2745 //WINMOVE,WM, ,Window &Move,Place Window,CS;SW;@;@;MV;@;@;
#define	CMD_WinCopy			2746 //WINCOPY,WC, ,Window &Copy, Place Window,CS;sw;@;@;co;
#define	CMD_ObjCopy			2747 //OBJCOPY,OC, ,Object C&opy, Select Object,CS;sb;@;co;
#define	CMD_ObjMove			2748 //OBJMOVE,OM, ,Object Mo&ve, Select Object,CS;SB;@;MV;@;@;
#define	CMD_WinRotate		2749 //WINROTATE,WT, ,Window &Rotate, Place Window,CS;SW;@;@;RO;
#define	CMD_DwgRotate		2750 //DWGROTATE,DT, ,&Drawing Rotate, ,SA;RO;
#define	CMD_WinChange		2751 //WINCHANGE,WG, ,Window Chan&ge, Place Window,CS;sw;@;@;cg;
#define	CMD_DwgChange		2752 //DWGCHANGE,DG, ,Drawing Change, ,sa;cg;
#define	CMD_WinScale		2753 //WINSCALE,WZ, ,Window Sc&ale,Place Window,CS;SW;@;@;SZ;@;
#define	CMD_DwgScale		2754 //DWGSCALE,DZ, ,Drawing Scal&e,Drawing Scale,CS;SA;SZ;@;
#define	CMD_ObjChange		2755 //OBJCHANGE,OG, ,&Object Change,Select Object to Change,CS;SB;@;CG;
#define	CMD_WinHatch		2756 //WinHatch,WH, ,Window &Hatch, Window Hatch,CS;SW;@;@;HS;
#define	CMD_WinFill			2757 //WinFill,WF, ,Window &Fill,Window Fill,CS;SW;@;@;FS;
#define	CMD_WizText			2758 //WIZTEXT,WIT,,Text Wizard,Text Wizard,DLLNAme;VCWiz32.dll;DLLFunName;VCWizard;DLLCmdLine;TEXT;DLLRUN;
#define	CMD_WizDim			2759 //WIZDIM,WID,,Dimension Wizard,Dimension Wizard,DLLNAme;VCWiz32.dll;DLLFunName;VCWizard;DLLCmdLine;DIMENSION;DLLRUN;
#define	CMD_WizDraw			2760 //WIZDRAW,WIR,,Drawing Wizard,Drawing Wizard,DLLNAme;VCWiz32.dll;DLLFunName;VCWizard;DLLCmdLine;DRAWING;DLLRUN;
#define	CMD_WizProp			2761 //WIZPROP,WIP,,&Drawing Properties,Drawing Properties,DLLNAme;VCWiz32.dll;DLLFunName;VCWizard;DLLCmdLine;PSHEET;DLLRUN;

// V3 commands
#define CMD_OSnapMode				2770
#define CMD_OSnapType				2771
#define CMD_OSnapPreview			2772
#define CMD_ApertureMode			2773

#define	CMD_RSEndPoint	2774
#define	CMD_RSObject	2775
#define	CMD_RSMidPoint	2776
#define	CMD_RSIntersec	2777
#define	CMD_RSPerpend	2778
#define	CMD_RSTangent	2779
#define	CMD_RSPercent	2780
#define	CMD_RSQuadrant	2781
#define	CMD_RSCenter	2782
#define	CMD_RSAll		2783

#define	CMD_DrawLineMid			2800 
#define	CMD_UserAlert				2801

#define TOKENTOOLLAST     3100


///======================================  OTHER        =================================================
///======================================  OTHER        =================================================
///======================================  OTHER        =================================================

#define TOKENOTHERFIRST  3101
#define CMD_Base  3101

#define CMD_BTProperty                     3102
#define CMD_FilterFromSelectionRibalog     3103
#define CMD_SelectionRibalogWithId         3104
#define CMD_SelLayerFromSelectionRibalog   3105
#define CMD_VCF                            3106
#define CMD_TrueType                       3107
#define CMD_Maximize                       3108
#define CMD_MaximizeDn                     3109


// Non WM_COMMAND messages sent to Main Window Frame
#define ID_Message  3101

#define ID_UpdateByExampleInspector			3101
#define ID_UpdateByExample							3102
#define ID_OpenToolbar                  3103
#define ID_StatusBar                    3104
#define ID_StatusBarToggles							3105// just need some id, wont interfere. Used by status bar toggles menu
#define ID_OpenLeftToolbar              3105
#define ID_CreateToolDialog             3106
#define ID_DeleteToolDialog             3107
#define MSG_EditChange                  3108
#define ID_UpdateControls								3109
#define ID_CurrDlgMessage								3110
#define MSG_DisplayDlgValues						3111
#define MSG_EditComplete                3112
#define ID_AbortCurrentDialog           3113
#define MSG_EditAbort                   3114

#define MSG_DispatchNextPoint						3115
#define MSG_DispatchCommand             3116
#define ID_ProcessTool                  3117
#define ID_CreateDialogModeless         3118
#define ID_OpenLastDrawing1             3119
#define ID_OpenLastDrawing2             3120
#define ID_OpenLastDrawing3             3121
#define ID_OpenLastDrawing4             3122
#define ID_OpenLastDrawing5             3123
#define ID_OpenLastDrawing6             3124
#define ID_OpenLastDrawing7             3125
#define ID_OpenLastDrawing8             3126
#define ID_OpenLastDrawing9             3127
#define ID_OpenLastDrawing10            3128
#define ID_OpenLastDrawing11            3129
#define ID_OpenLastDrawing12            3130
#define ID_OpenLastDrawing13            3131
#define ID_OpenLastDrawing14            3132
#define ID_OpenLastDrawing15            3133
#define ID_OpenLastDrawing16            3134
#define ID_CreateToolDialogWithId       3135
#define ID_GetDialogFromId				3136
#define ID_CreateToolModal              3140
#define ID_CreateToolModalWithId        3141
#define ID_CreateDialogModal            3142
#define ID_UpdateManager                3143
#define ID_AllWorldsDestroyed           3144
#define MSG_METERSTART                  3145
#define MSG_METERSTOP                   3146
#define MSG_METERSTEP                   3147
#define ID_DeleteDialog                 3148
#define MSG_ReleaseMouseMenu            3139
#define MSG_RegenMerge                  3150
#define MSG_DrawEntity                  3151
#define MSG_UpdateBirdsEyeView          3152
#define MSG_MyMsgBox					3153
#define MSG_DIGPOINT                    3154
#define ID_UpdateProperties				3155
#define	ID_UpdateByExampleMulti			3156
#define ID_HatchErrorDlg				3157

// symbol manager messages
#define ID_CreateFromDrag				3160
#define ID_AbortCreateFromDrag			3161

#define ID_PersistentTools				3170
#define ID_MenuShortcuts				3171


// HARD TO CATEGORIZE Section

#define CMD_Misc  3301

#define CMD_FontName        3308
#define DBaseDlgReset       3309
#define ID_RestoreToolbar   3310
#define CMD_Macro           3312
#define CMD_Hint            3313
#define CMD_DlgOk           3315
#define CMD_DlgMatch        3316
#define CMD_DefaultTool          3329
#define CMD_ShowAngle2  3333
#define CMD_ShowAngle3  3334
#define CMD_ShowDist  3335
#define CMD_AutomationMacro   3344
#define CMD_AttributeEmbedDlg           3368
#define CMD_AttributeCreateDlg          3369
#define CMD_AttributeAttachDlg          3370
#define CMD_SpecificAttributeAttachDlg  3371
#define CMD_AttributeEditDlg            3372
#define CMD_UpdateControls              3373
#define CMD_OLEDrawingDirty             3374
#define CMD_RegEdit                     3375
#define ID_MESSAGE                      3376
					 

// Windows Section

#define CMD_Windows				3401

#define IDM_WINDOWCHILD         3408
			
// Non Tool Settings
#define NonToolBase   6101
// all non tool commands defined between  CMD_NonToolBase & CMD_NonToolBaseEnd

// Drawing Settings
#define CMD_DrawingSettings    6101
#define CMD_RPolygonNSides3  6106
#define CMD_RPolygonNSides4  6107
#define CMD_RPolygonNSides5  6108
#define CMD_RPolygonNSides6  6109
#define CMD_RPolygonNSides7  6110
#define CMD_RPolygonNSides8  6111
#define CMD_RPolygonNSides9  6112
#define CMD_RPolygonNSides10  6113
#define CMD_RPolygonNSides11  6114
#define CMD_RPolygonNSides12  6115
#define CMD_LeftJustify       6117
#define CMD_LeftJustifyDn     6118
#define CMD_CenterJustify     6119
#define CMD_CenterJustifyDn   6120
#define CMD_RightJustify      6121
#define CMD_RightJustifyDn    6122
#define CMD_Bold              6123
#define CMD_BoldDn            6124
#define CMD_Italic            6125
#define CMD_ItalicDn          6126
#define CMD_MEAbsolute        6127
#define CMD_MERelative        6128
#define CMD_MEBasepoint       6129
#define CMD_RPolygonInscribed 6130
#define CMD_Underline         6131
#define CMD_UnderlineDn       6132
#define CMD_Strikeout         6133
						                                                                                                                                                                                                                                                                

// Bool commands
#define CMD_Bool  6501

// all NON tool commands defined between  CMD_3000+1000+1024+76+1000+1 & CMD_NonToolBaseEnd
#define NonToolBaseEnd   6601
#define LASTVALIDTOKEN  6601


// General string entity names, error messages
#define ID_StringTable			6601
#define IDS_Dimension           6602
#define IDS_Entity              6603
#define IDS_Hatch               6604
#define IDS_Fill                6605
#define IDS_Attribute           6606
#define IDS_Text                6607
#define IDS_Absolute            6608
#define IDS_Relative            6609
#define IDS_Basepoint           6610

// Numeric tab dialog								
#define         IDS_Inch                               6611
#define         IDS_Feet                               6612
#define         IDS_FeetInch                           6613
#define         IDS_Mile                               6614
#define         IDS_MM                                 6615
#define         IDS_CM                                 6616
#define         IDS_Meter                              6617
#define         IDS_Kilo                               6618

// dialog template names updated for Win95 and filters
#define IDS_FileOpenFilter                   6619
#define IDS_FileSaveFilter                   6620
#define IDS_FileOpenTemplateName             6621
#define IDS_FileSaveTemplateName             6622
#define IDS_FileOpenTitle                    6623
#define IDS_FileSaveTitle                    6624

#define IDS_SymbolLoadFilter                 6625
#define IDS_SymbolSaveFilter                 6626
#define IDS_SymbolSaveTemplateName           6627
#define IDS_SymbolLoadTitle                  6628
#define IDS_SymbolSaveTitle                  6629

#define IDS_StyleLoadFilter                  6630
#define IDS_StyleLoadTitle                   6631
#define IDS_StyleSaveFilter                  6632
#define IDS_StyleSaveTitle                   6633

#define IDS_AtbLoadFilter                 6634
#define IDS_AtbSaveFilter                 6635
#define IDS_AtbSaveTemplateName           6636
#define IDS_AtbLoadTitle                  6637
#define IDS_AtbSaveTitle                  6638

#define IDS_FileMergeFilter              6639
#define IDS_FileMergeTemplateName        6640
#define IDS_FileMergeTitle               6641

#define IDS_LoadMenuFilter               6642
#define IDS_LoadMenuTitle                6643

#define IDS_BrowseFilter                 6644
#define IDS_BrowseTemplateName           6645
#define IDS_BrowseTitle                  6646

#define IDS_LoadAsciiFilter              6647
#define IDS_LoadAsciiTitle               6648

#define IDS_FileOpenBtnTemplateName      6649

// Keep original template names for NT
#define IDS_FileOpenTemplateNameNT       6650
#define IDS_FileSaveTemplateNameNT       6651
#define IDS_SymbolSaveTemplateNameNT     6652
#define IDS_AtbSaveTemplateNameNT        6653
#define IDS_FileMergeTemplateNameNT      6654
#define IDS_BrowseTemplateNameNT         6655

// Use this for saving if "Allow EMF==1" in Registry
#define IDS_FileSaveWithEMFFilter        6656

#define IDS_FontConvertFilter            6660
#define IDS_FontConvertTitle             6661
#define IDS_FontConvertTemplateName      6662
#define IDS_FontConvertTemplateNameNT    6663

#define IDS_AbsoluteFull            6670
#define IDS_RelativeFull            6671
#define IDS_BasepointFull           6672

#define IDS_FRAC	6673

// script constants
// 2K of Script commands, ok that they overlap the Help ids
#define ScriptBase    6602
#define CMD_Script001   6603
#define ScriptLast    	8652	// 2048 commands

#define HelpID_Base            7602
// Beginning of Context Help ID's -- 7602
#define HID_OK                7875              // General button definitions--common to all dialogs
#define HID_Cancel            7874
#define HID_Browse            8010
#define HID_PrintDlg           7602
// Print will start the ID's
#define HID_PlotDlg            7652
#define HID_PlotSettings       7702
#define HID_PlotPenMap         7752
#define HID_PlotLanguage       7802
#define HID_TabGeneral         7852
#define HID_TabConstraint      7902
#define HID_TabSystem          7952
#define HID_TabPath            8002
#define HID_TabHatchFill       8052
#define HID_TabTextAtb         8102
#define HID_TabLeader          8152
#define HID_TabDimension       8202
#define HID_TabDimText         8252
#define HID_TabNumeric         8302
#define HID_TabGCDSettings     8352
#define HID_TabGCDFontImport   8402
#define HID_TabGCDFontExport   8452
#define HID_TabDWGSettings     8502
#define HID_TabDWGFontImport   8552
#define HID_TabDWGFontExport   8602
#define HID_TextEditor         8652
#define HID_TextLine           8702
#define HID_ATBCreate          8752
#define HID_ATBAttach          8802
#define HID_ATBEmbed           8852
#define HID_SymbolMgr          8902
#define HID_LayerMgr           8952
#define HID_ATBEdit            9002
#define HID_PrintSetup         9052
#define HID_PrintMargins       9057
#define HID_Miscellaneous      9102
#define HID_CommonDialogs      9102
#define HID_Styles             9109
#define HID_Run                9119
#define HID_SymbolRemove       9120
#define HID_ObjectInfo         9124
#define HID_ToolBars           9126
#define IDS_BrowseGFont		   9127
#define IDS_BrowseAFont		   9128
#define HID_TabSystem2		   9202

#endif //#ifndef CMDS_H_INCLUDED
